var tooltips = document.getElementsByClassName('bh-tooltip-trigger');
var tips = document.querySelectorAll('.bh-tooltip-tip');

//show tooltip on click of its trigger
for (var i = 0; i < tooltips.length; i++) {
    var tooltipTrigger = tooltips[i];

    tooltipTrigger.addEventListener('click', function() {
        var tip = this.nextElementSibling;

        //close open tips that aren't this one
        for (var i = 0; i < tips.length; i++) {
            if (tips[i].classList.contains('shown') && tips[i] !== tip) {
                tips[i].classList.remove('shown');
            }
        }

        //hide/show clicked tip
        tip.classList.toggle('shown');

    });
}

//close tooltip when clicking outside of it
document.addEventListener('click', function(event) {
    var openTip = document.querySelector('.bh-tooltip-tip.shown');
    var tooltipTrigger = 'bh-tooltip-trigger';

    //if there is a tooltip open and the click event isn't a tooltip trigger
    if (openTip 
        && !event.target.classList.contains(tooltipTrigger)
        && !event.target.parentNode.classList.contains(tooltipTrigger)) {
        openTip.classList.remove('shown');
    }
});

//hide any tooltips if 'esc' key is hit
document.addEventListener('keyup', function(event) {
    if (event.keyCode === 27) { //escape key
        tips.forEach(function(tip){
            tip.classList.remove('shown');
        });
    }
});
