var ssnFields = document.querySelectorAll('.bh-text-input-ssn-input'),
    ssnLength = 15;

//formats SSN to xxx - xx - xxxx
var formatSSN = function(ssnField) {
    var x = ssnField.value.replace(/\D/g, '').match(/(\d{0,3})(\d{0,2})(\d{0,4})/);
    ssnField.value = !x[2] ? x[1] : x[1] + ' - ' + x[2] + (x[3] ? ' - ' + x[3] : '');
}

//adds error state if SSN number is not complete
var validateSSNLength = function(ssnField) {
    var valLength = ssnField.value.length;
    if (valLength < ssnLength && valLength != 0) {
        ssnField.parentNode.classList.add('bh-form-field-error');
    } else if (valLength == 0 && ssnField.hasAttribute('required')) {
        ssnField.parentNode.classList.add('bh-form-field-error');
    } else {
        ssnField.parentNode.classList.remove('bh-form-field-error');
    }
}

//listeners for all SSN fields
for (var i = 0; i < ssnFields.length; i++) {
    ssnFields[i].addEventListener('blur', function() {
        validateSSNLength(this);
    });

    ssnFields[i].addEventListener('input', function() {
        formatSSN(this);
    });
}

    