var phoneFields = document.querySelectorAll('.bh-text-input-phone-input'),
    phoneLength = 14;

//formats phone number to (xxx) xxx-xxxx on input
var formatPhoneNumber = function(phoneField) {
    var x = phoneField.value.replace(/\D/g, '').match(/(\d{0,3})(\d{0,3})(\d{0,4})/);
    phoneField.value = !x[2] ? x[1] : '(' + x[1] + ') ' + x[2] + (x[3] ? '-' + x[3] : '');
}

//adds error state if phone number is not complete
var validatePhoneLength = function(phoneField) {
    var valLength = phoneField.value.length;
    if (valLength < phoneLength && valLength != 0) {
        phoneField.parentNode.classList.add('bh-form-field-error');
    } else if (valLength == 0 && phoneField.hasAttribute('required')) {
        phoneField.parentNode.classList.add('bh-form-field-error');
    } else {
        phoneField.parentNode.classList.remove('bh-form-field-error');
    }
}

//listeners for all phone fields
for (var i = 0; i < phoneFields.length; i++) {
    phoneFields[i].addEventListener('blur', function() {
        validatePhoneLength(this);
    });

    phoneFields[i].addEventListener('input', function() {
        formatPhoneNumber(this);
    });
}