var dobFields = document.querySelectorAll('.bh-text-input-dob-input'),
    dobLength = 10;

//formats DOB to mm/dd/yyyy
var formatDOB = function(dobField) {
    var x = dobField.value.replace(/\D/g, '').match(/(\d{0,2})(\d{0,2})(\d{0,4})/);
    dobField.value = !x[2] ? x[1] : x[1] + '/' + x[2] + (x[3] ? '/' + x[3] : '');
}

//adds error state if DOB is not complete
var validateDOBLength = function(dobField) {
    var valLength = dobField.value.length;
    if (valLength < dobLength && valLength != 0) {
        dobField.parentNode.classList.add('bh-form-field-error');
    } else if (valLength == 0 && dobField.hasAttribute('required')) {
        dobField.parentNode.classList.add('bh-form-field-error');
    } else {
        dobField.parentNode.classList.remove('bh-form-field-error');
    }
}

//show helper message after typing in input field
var toggleHelperDOB = function(dobField) {
    if (dobField.value.length > 0) {
        dobField.nextElementSibling.classList.add('shown');
    } else {
        dobField.nextElementSibling.classList.remove('shown');
    }
}

//listeners for all DOB fields
for (var i = 0; i < dobFields.length; i++) {
    dobFields[i].addEventListener('keyup', function() {
        toggleHelperDOB(this);
    });

    dobFields[i].addEventListener('blur', function() {
        validateDOBLength(this);
    });

    dobFields[i].addEventListener('keyup', function() {
        if (this.value.length == dobLength) {
            this.parentNode.classList.remove('bh-form-field-error');
        }
    });

    dobFields[i].addEventListener('input', function() {
        formatDOB(this);
    });
}

    