const step1form = document.querySelector('.bh-intake-template-form-step-1'),
      step2form = document.querySelector('.bh-intake-template-form-step-2'),
      step1next = document.querySelector('.bh-intake-template-step-1-forward'),
      step1back = document.querySelector('.bh-intake-template-step-1-back'),
      step2back = document.querySelector('.bh-intake-template-step-2-back'),
      step1required = document.querySelectorAll('.bh-intake-template-form-step-1 .bh-intake-template-select'),
      step1progress = document.querySelector('.bh-intake-template-progress-step--1'),
      step2progress = document.querySelector('.bh-intake-template-progress-step--2'),
      step2summary = document.querySelector('.bh-intake-template-summary-step-2'),
      step2callbackTime = document.querySelector('.bh-intake-template-card-description--callback-time'),
      step2therapyType = document.querySelector('.bh-intake-template-card-description--therapy-type'),
      callbackTimeField = document.querySelector('.bh-intake-template-callback-time'),
      therapyTypeField = document.querySelector('.bh-intake-template-therapy-type'), 
      callbackEditButton = document.querySelector('.bh-intake-template-edit-callback-time-button'),
      therapyTypeField2 = document.querySelector('.bh-intake-template-textarea');

if (step1next) {
    step1next.addEventListener('click', function() {

        //show/hide error message if field is left empty
        step1required.forEach(function(question) {
            let fieldValue = question.querySelector('.bh-select-field').value;

            if (fieldValue == 'none') {
                question.classList.add('bh-form-field-error');
            } else {
                question.classList.remove('bh-form-field-error');
            }

            question.querySelector('.bh-select-field').addEventListener('change', function() {
                if (this.value !== 'none') {
                    question.classList.remove('bh-form-field-error');
                }
            });

        });

        //if there are no form errors, go to page 2
        if (document.querySelectorAll('.bh-intake-template-form-step-1 .bh-form-field-error').length == 0) {
            goToStep2();
        }
    });
}

if (step1back) {
    step1back.addEventListener('click', function() {
        window.location.href = '/';
    });
}

if (step2back) {
    step2back.addEventListener('click', function() {
        goToStep1();
    });
}

if (callbackEditButton) {
    callbackEditButton.addEventListener('click', function() {
        goToStep1();
    });
}

if (therapyTypeField) {
    therapyTypeField.addEventListener('change', function() {
        if (this.value == 'Other') {
            therapyTypeField2.style.display = 'block';
            therapyTypeField2.querySelector('textarea').focus();
        } else {
            therapyTypeField2.style.display = 'none';
            therapyTypeField2.classList.remove('bh-form-field-error');
        }
    });
}

const goToStep1 = function() {
    step1form.style.display = 'block';
    step1back.style.display = 'flex';
    step1progress.classList.add('progress-step-filled');
    step2form.style.display = 'none';
    step2back.style.display = 'none';
    step2progress.classList.remove('progress-step-filled');
    step2summary.style.display = 'none';
}

const goToStep2 = function() {
    step1form.style.display = 'none';
    step1back.style.display = 'none';
    step1progress.classList.remove('progress-step-filled');
    step2form.style.display = 'block';
    step2back.style.display = 'flex';
    step2progress.classList.add('progress-step-filled');
    step2summary.style.display = 'block';
    step2callbackTime.innerText = callbackTimeField.value;
    step2therapyType.innerText = therapyTypeField.value + (therapyTypeField.value == 'Other' ? ` - ${therapyTypeField2.querySelector('textarea').value}` : '');
}