var buildPagination = function() {
    $('.pagination-nav-example').html('');
    $('.pagination-nav-example').materializePagination({
        firstPage: 1,
        lastPage: 50,
        urlParameter: 'page',
        useUrlParameter: false,
        maxVisiblePages: 7,
        showWords: true,
        smallVersion: false,
        responsive: [
            {
                breakpoint: 1105,
                settings: {
                    maxVisiblePages: 5
                }
            },
            {
                breakpoint: 1010,
                settings: {
                    maxVisiblePages: 3
                }
            },
            {
                breakpoint: 675,
                settings: {
                    showWords: false,
                    smallVersion: true
                }
            }
        ],
        onClickCallback: function(requestedPage){
            console.log('Requested page is '+ requestedPage);
        }
    });
}

window.addEventListener('DOMContentLoaded', buildPagination);
window.addEventListener('resize', buildPagination);