var activeAlerts = document.getElementsByClassName('bh-active-alert');

//close alert when clicking on the X - also used for when alert is swiped away or faded away on scroll
var closeActiveAlert = function(activeAlertId, useFadeOut = false) {
    var activeAlert = document.querySelector('#' + activeAlertId);
    activeAlert.classList.remove('open');
    activeAlert.setAttribute('aria-hidden', true);

    if (useFadeOut) {
        activeAlert.classList.add('fade-out');
        setTimeout(function() {
            activeAlert.classList.add('mobile-hidden');
        }, 1000);
    } else {
        activeAlert.classList.add('mobile-hidden');
    }
}

for (var i = 0; i < activeAlerts.length; i++) {
    activeAlerts[i].addEventListener('click', function(e) {
        if (!e.target.hasAttribute('bh-active-alert-close')) return;
        closeActiveAlert(this.id, true);
    });
}

//if the alerts have data-bh-fade-out-type of scroll, check their data-bh-fade-out-at attribute and hide the alert when that ID is hit (mobile only)
var activeAlertsScroll = document.querySelectorAll('.bh-active-alert[data-bh-fade-out-type="scroll"]');
if (activeAlertsScroll.length) {
    window.addEventListener('scroll', function() {
        if (window.innerWidth < 768) {
            for (var i = 0; i < activeAlertsScroll.length; i++) {
                var element = document.querySelector('#' + activeAlertsScroll[i].getAttribute('data-bh-fade-out-at')),
                    position = element.getBoundingClientRect();
                
                // checking for partial visibility
                if (position.top < window.innerHeight && position.bottom >= 0) {
                    closeActiveAlert(activeAlertsScroll[i].id, true);
                }
            }
        }
    });
}

//if the alerts have data-bh-swipe-hide attribute, add the custom event
var activeAlertsSwipe = document.querySelectorAll('.bh-active-alert[data-bh-swipe-hide]');
if (activeAlertsSwipe.length) {
    for (var i = 0; i < activeAlertsSwipe.length; i++) {
        activeAlertsSwipe[i].addEventListener('swiped-left', function(e) {
            var alertId = this.id;
            this.classList.add('swiped-away'); 
            
            setTimeout(function() {
                closeActiveAlert(alertId, false);
            }, 1000);
        });
    }
}