const inlineNotis = document.querySelectorAll('.bh-notification-inline'),
      inlineCloseButtons = document.querySelectorAll('[bh-notification-close]');

var closeInlineNoti = function(notiID) {
    var noti = document.querySelector('#' + notiID);
    noti.classList.remove('open');
    noti.setAttribute('aria-hidden', true);
}

window.addEventListener('DOMContentLoaded', (event) => {
    inlineNotis.forEach(function(noti) {
        if (noti.hasAttribute('data-bh-noti-timeout')) {
            var timeoutAmt = noti.getAttribute('data-bh-noti-timeout');
            setTimeout(function() {
                noti.classList.remove('open');
                noti.setAttribute('aria-hidden', true);
            }, timeoutAmt);
        }
    });
});

inlineCloseButtons.forEach(function (closeButton) {
    closeButton.addEventListener('click', function(e) {
        const thisNoti = this.closest('.bh-notification-inline').id;
        closeInlineNoti(thisNoti);
    });
});